package gov.va.vinci.dart.json;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="document", propOrder={
		"id",
		"headId",
		"name",
		"description",
		"requirement",
		"createdBy",
		"createdOn",
		"updatedBy",
		"updatedOn",
		"versionNumber",
		"docType",
		"uploaded",
		"editable",
		"reviewStatus",
		"sortOrder",
		"contentId",
		"onlyOneVersion",
		"docVersions",
		"reviewNotes"
})
public class DocumentView implements Comparable {

	private int id;	
	private int headId;
	private String name;
	private String description;
	private String requirement;
	private String createdBy;
	private String createdOn;
	private String updatedBy;
	private String updatedOn;
	private int versionNumber;
	private String docType;
	private boolean uploaded;
	private boolean editable = false;
	private String reviewStatus;
	private int sortOrder;
	private int contentId;
	private boolean onlyOneVersion = false;
	
	@XmlElement(name="note")
	private List<DocumentReviewNoteView> reviewNotes = new ArrayList<DocumentReviewNoteView>();

	@XmlElement(name="version")
	private List<DocumentVersionView> docVersions = new ArrayList<DocumentVersionView>();	//previous versions of this document
	
	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getCreatedBy() {
		return createdBy;
	}

	public void setCreatedBy(String createdBy) {
		this.createdBy = createdBy;
	}

	public String getCreatedOn() {
		return createdOn;
	}

	public void setCreatedOn(String createdOn) {
		this.createdOn = createdOn;
	}

	public String getUpdatedBy() {
		return updatedBy;
	}

	public void setUpdatedBy(String updatedBy) {
		this.updatedBy = updatedBy;
	}

	public String getUpdatedOn() {
		return updatedOn;
	}

	public void setUpdatedOn(String updatedOn) {
		this.updatedOn = updatedOn;
	}

	public int getVersionNumber() {
		return versionNumber;
	}

	public void setVersionNumber(int versionNumber) {
		this.versionNumber = versionNumber;
	}

	public String getDocType() {
		return docType;
	}

	public void setDocType(String docType) {
		this.docType = docType;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getRequirement() {
		return requirement;
	}

	public void setRequirement(String requirement) {
		this.requirement = requirement;
	}
	
	public boolean isUploaded() {
		return uploaded;
	}

	public void setUploaded(boolean uploaded) {
		this.uploaded = uploaded;
	}

	public boolean isEditable() {
		return editable;
	}

	public void setEditable(boolean editable) {
		this.editable = editable;
	}

	public String getReviewStatus() {
		return reviewStatus;
	}

	public void setReviewStatus(String reviewStatus) {
		this.reviewStatus = reviewStatus;
	}

	public List<DocumentReviewNoteView> getReviewNotes() {
		return reviewNotes;
	}

	public int getSortOrder() {
		return sortOrder;
	}

	public void setSortOrder(int sortOrder) {
		this.sortOrder = sortOrder;
	}
	
	public int getContentId() {
		return contentId;
	}

	public void setContentId(int contentId) {
		this.contentId = contentId;
	}

	public boolean isOnlyOneVersion() {
		return onlyOneVersion;
	}

	public void setOnlyOneVersion(boolean onlyOneVersion) {
		this.onlyOneVersion = onlyOneVersion;
	}
	
	public List<DocumentVersionView> getDocVersions() {
		return docVersions;
	}
	
	
	public int getHeadId() {
		return headId;
	}

	public void setHeadId(int headId) {
		this.headId = headId;
	}

	
	
	@Override
	public int compareTo(Object o) {
		if (o == null) {
			return -1;
		}
		if (DocumentView.class.isAssignableFrom(o.getClass()) == false) {
			return -1;
		}
		
		DocumentView doc2 = (DocumentView)o;

		if (doc2.sortOrder == this.sortOrder) {
			return 0;
		}
		return (doc2.sortOrder < this.sortOrder) ? 1: -1;
	}
}
